<?php
  date_default_timezone_set("Europe/Warsaw");
  require("config.php");
  require("users_stats.php");
  
  header("Content-type: text/plain");
  header("Content-Disposition: attachment; filename="."wp_".date("Y-m-d")."_".date("H")."_".date("i").".csv");

  print '"user id";"user name";"host";"workbench";"#items current hour";"#items last hour";"#items processed";"avg items per hour";'."\n";
  
  $users = getUserStats( '2018-11-06');
  if ( !empty($users))
  {       
    foreach ( ($users) as $key=>$value) 
    {
      if ( isset($value['login']))
      {
        print '"'.$value["login"].'";';
      }
      else
          print ';';
          
      if (isset($value["name"]))
          print '"'.$value["name"].'";';
      else
        print ';';
        
      if ( isset($value["host"]))
        print '"'.$value["host"].'";';
      else
        print ';';
        
      if ( isset($value["workbench"]))
        print '"'.$value["workbench"].'";';
      else
        print ';';
        
      
      if ( isset($value["current_hour"]))
        print $value["current_hour"].';';
      else
        print ';';
        
      if ( isset($value["last_hour"]))
        print $value["last_hour"].';';
      else
        print ';';
        
      print $value["items_processed"].';';
      print number_format($value["avg"],2,',','').';';
      print "\n";	
    }
  }   
  

?>